/*******************************************************************************
*  sunGlint.h
*  Header file to declare all function prototypes
*
*******************************************************************************/

#ifndef _C_SUNGLINT_H
#define _C_SUNGLINT_H

/*******************************************/
/* function to compute the sun glint angle */
/*******************************************/
double sunGlintAngle(double lat, double lon, double sclat, double sclon, double scalt,int year, int month, int day, int hour, int min,float fsec, double *zasun, double *zaview, double *sun_view_az);

/***************************************/
/* functions called by sunGlintAngle() */
/***************************************/
int getSunVecECR(int year,int doy,float secs_of_day ,double, double sunVec[3]);

double getSunGlintAng(double lat, double lon, double sclat, double sclon, double scalt,double sunVec[3], double *zasun, double *zaview, double *sun_view_az);


/******************************************************************/
/* utility functions called by getSunGlintAng() and getSunVecECR()*/
/******************************************************************/

int getDOY(int year,int month,int day,int hour,int min,float fsec,float *secs_of_day);
int date2jdaySG(int year,int month,int day);
int sun2000SG(long iyr,long iday,double sec,double sun[3],double *rs);
int gha2000SG(long iyr,double day,double *gha);
long jdSG(long i,long j,long k);
int ephparmsSG(double t, double *xls,double *gs,double *xlm,double *omega);
int nutateSG(double t,double xls,double gs,double xlm,double omega,
           double *dpsi,double *eps);
void getVecECR(double clat, double clon, double slat, double slon, double xalt, double ECRvec[3]);



#endif
