/**************************************************************************
* example.c
*
* A simple program shows how to compute the sun glint angle
* (the separation angle between the sun and the reflected view)
* using sunGlintAngle(). 
*
* Note: must include "sunGlint.h" 
*
****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "sunGlint.h"           /* include file for sunGlint.a */
 
int main(int argc, char *argv[])
{
    /* input parameters for sunGlintAngle() */ 
    int     year,month,day,hour,min;
    float   fsec;
    double  sclat,sclon,scalt; /* satellite latitdue, longitude (deg) and altitude (Km) */
    double  lat,lon;           /* pixel latitdue, longitude (deg) */ 

    /* output parameters for sunGlintAngle() */ 
    double  zasun;             /* solar zenith angle (deg) */
    double  zaview;            /* view zenith angle (deg) */
    double  sun_view_azim;     /* azimuth angle between the sun and view (deg) */
    double  glintAng;          /* sun glint angle (deg) */

    int     i,j;


    /* assign the input time */
    year=2000;
    month=1;
    day=27;
    hour=16;
    min=19;
    fsec=10.0;

    /* assign satellite location */
    sclat=17.0286;
    sclon=-139.5470;
    scalt=345.6855;

    /* assign pixel's location */
    lat=18.2537;
    lon=-135.8779;

    /**************************/
    /* compute sunglint angle */
    /**************************/
    glintAng=sunGlintAngle(lat,lon,sclat,sclon,scalt,
                           year,month,day,hour,min,fsec,
                           &zasun,&zaview,&sun_view_azim);

    /* print output */
    printf("%10.4f %10.4f %10.4f %10.4f %10.4f %4d %2d %2d %2d %2d %4.1f %10.4f %10.4f %10.4f %10.4f\n",
            lat,lon,sclat,sclon,scalt,year,month,day,hour,min,fsec,
            glintAng,zasun,zaview,sun_view_azim);



    /* more tests */
    for(i=0;i<30;i++)
    {
      lat=(double)i;
      for(j=-140;j<-120;j++)
      {
          lon=(double)j;
          glintAng=sunGlintAngle(lat,lon,sclat,sclon,scalt,
                                 year,month,day,hour,min,fsec,
                                 &zasun,&zaview,&sun_view_azim);
           
          printf("%10.4f %10.4f %10.4f %10.4f %10.4f %4d %2d %2d %2d %2d %4.1f %10.4f %10.4f %10.4f %10.4f\n",
                  lat,lon,sclat,sclon,scalt,year,month,day,hour,min,fsec,
                  glintAng,zasun,zaview,sun_view_azim);

      }
    }

    return 0;
}
