C*******************************************************************************
C*
C*  SUBROUTINE getVecECR()
C*
C*  Description:
C*    Compute the position vector in ECR coordinates.
C*
C*  Input parameters:
C*    clat         double     cos(Geodetic latitude)
C*    clon         double     cos(Geodetic longitude)
C*    slat         double     sin(Geodetic latitude)
C*    slon         double     sin(Geodetic longitude)
C*    alt          double     Altitude (Km)
C*
C*  Output:
C*    ECRvec(3)    double     position vector in ECR coordinates
C*
C*
C* Log:
C*   10/25/2006        Joyce Chou        first created
C*
C***********************************************************************

C23456789012345678901234567890123456789012345678901234567890123456789012
      SUBROUTINE getVecECR(clat,clon,slat,slon,alt,ECRvec)

      implicit none

C-----input parameters
      double precision clat,clon,slat,slon,alt

C-----output parameter
      double precision ECRvec(3)

C-----define constants
C-----DEG2RAD:PI/180.0
C-----R_EQUATOR: Radius of the Earth equator in km
C-----FLATC: Earth's oblateness coefficient
C-----lEcc2= 2.0*FLATC-FLATC*FLATC
      double precision DEG2RAD,R_EQUATOR
      parameter (DEG2RAD=0.017453292,R_EQUATOR=6378.137) 
      double precision FLATC,lEcc2          
      parameter (FLATC=0.00335281,lEcc2=0.0066943787)
      
      double precision up(3)
      double precision Z      
      double precision XY      
      double precision epsilon, nc

      epsilon = 1.0 / sqrt(1.0 - lEcc2 * slat * slat)
      nc = epsilon * R_EQUATOR

C---  Calculate the Z component of the position vector  

      Z = nc * (1.0 - lEcc2) * slat

C---  Calculate the XY plane magnitude of the Gvec  

      XY = nc * clat

C---  Calculate the X component of the position vector

      ECRvec(1) = XY * clon
      ECRvec(2) = XY * slon
      ECRvec(3) = Z

C---  If there is a altitude, do altitude adjustment

      if(alt .GT. 0.00001) then 
        up(1) = clon*clat
        up(2) = slon*clat
        up(3) = slat
        ECRvec(1) =ECRvec(1) +up(1)*alt
        ECRvec(2) =ECRvec(2) +up(2)*alt
        ECRvec(3) =ECRvec(3) +up(3)*alt
      endif

      RETURN
      END

 
