C*******************************************************************
C* FUNCTION sunGlintAngle()
C*
C* Description:
C*   This function takes the pixel location, satllite location
C*   and time information and calculates the sun glint
C*   angle and return the computed sun glint angle in degree.
C*
C* Input parameters:
C*   double lat     -geodetic latitude (deg) of the pixel [-90, 90]
C*   double lon     -geodetic longitude (deg) of the pixel [-180,180]
C*   double sclat   -geodetic latitude (deg) of the satellite [-90, 90]
C*   double sclon   -geodetic longitude (deg) of the satellite [-180,180]
C*   double scalt   -altitude (Km) of the satellite
C*   int    year    -4 digit year
C*   int    month   -month  [1,12]
C*   int    day     -day of the month [1,31]
C*   int    hour    -hour [0,23]
C*   int    min     -minute [0,59]
C*   float  fsec    -second including fractional part [0,59.999]
C*
C* Output parameters:
C*   double zasun         -sun zenith angle in degree [0, 180]
C*   double zaview        -view zenith angle in degree [0, 180]
C*   double sun_view_azim -azimuth angle between the sun and view
C*                         vector in degree [-180, 180]
C*                         a value of -9999.0 indicates pixel not in view or
C*                         sun not on pixel
C*
C* Return:
C*   double sunGlintAng  -the sun glint angle (the seperation angle
C*                        between the sun vector and reflected view
C*                        vector) in degree [0, 180]
C*                        a value of -9999.0 indicates pixel not in view or
C*                        sun not on pixel
C* Routines called:
C*   getDOY()
C*   gha2000SG()
C*   getSunVecECR()
C*   getSunGlintAng()
C*
C* Note :
C*
C*   GCI, ECI, GEI      -Geocentric Equatorial Inertial Coordinates
C*   ECR, ECEF          -Earth Centered Rotating Coordinates or
C*                       Earth Centered, Earth Fixed Coordinates
C*
C* Log:
C*   10/26/2006          Joyce Chou      first created
C*
C**********************************************************************

c23456789012345678901234567890123456789012345678901234567890123456789012

      double precision FUNCTION sunGlintAngle(lat,lon,sclat,sclon,scalt,
     &year,month,day,hour,min,fsec,zasun,zaview,sun_view_azim)
  
      implicit none
       
C-----input parameters
      double precision lat,lon,sclat,sclon,scalt
      integer*4 year,month,day,hour,min
      real*4 fsec

C-----output parameters
      double precision zasun,zaview,sun_view_azim

C-----sun vector in ECR
      double precision sunVec(3)
C-----Greenwich hour angle (rad)
      double precision GHA
C-----seconds of the day as a float
      real*4 secs_of_day
C-----fractional day of the year as a double
      double precision fdoy
C-----day of the year
      integer*4 doy

C-----declare functions
      integer*4 getDOY
      double precision getSunGlintAng


C----------------------------------------------------------------------------
C---  get the unit sun position vector in ECR for the given time
C----------------------------------------------------------------------------
C-----get the day of year
      doy=getDOY(year,month,day,hour,min,fsec,secs_of_day)

C-----get the fractional day of year
      fdoy=DBLE(secs_of_day)/86400.0+DBLE(doy)

C-----get the Greenwich hour angle
      CALL gha2000SG(year,fdoy,GHA)

C-----get the unit sun vector in ERC
      CALL getSunVecECR(year,doy,secs_of_day,GHA,sunVec)


C----------------------------------------------------------------------------
C---  get the sunglint angle which is the separation angle between
C---  the reflected view and Sun vector.
C---  also get the side products: zaview, zasun and sun_view_az
C----------------------------------------------------------------------------

      sunGlintAngle=getSunGlintAng(lat,lon,sclat,sclon,scalt,sunVec,zasu
     +n,zaview,sun_view_azim)

      RETURN
      END

      
       


